---
title: Stable Diffusion 3 API Usage Guide
slug: NkdKBoGp8nXHnLvwsRNfG
createdAt: Thu Jul 18 2024 06:09:30 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:41:12 GMT+0000 (Coordinated Universal Time)
---

# Stable Diffusion 3 API Usage Guide

## Introduction

This document will guide developers on how to use the aonet library to call the Stable Diffusion 3 API for generating AI art images.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Installation

Ensure that the aonet library is installed. If it is not installed yet, you can install it using npm:

```bash
npm install aonet
```

## Steps to Use

### 1. Import the aonet library

```js
const AI = require("aonet");
```

### 2. Configure Options

Create an options object that includes your APPID:

```js
const options = {
    appid: "your APPID"
};
```

Make sure to replace "your APPID" with your actual Aonet APPID.

### 3. Initialize AI Instance

Initialize the AI instance using the configuration options:

```js
const aonet = new AI(options);
```

### 4. Call the Stable Diffusion 3 API

Use the `prediction` method to call the Stable Diffusion 3 API:

```js
async function generateImage() {
    try {
        let response = await aonet.prediction("/predictions/ai/stable-diffusion-3",
        {
            input: {
                "cfg": 3.5,
                "prompt": "a photo of vibrant artistic graffiti on a wall saying \"SD3 medium\"",
                "aspect_ratio": "3:2",
                "output_format": "webp",
                "output_quality": 90,
                "negative_prompt": ""
            }
        });
        console.log("Stable Diffusion 3 result:", response);
    } catch (error) {
        console.error("Error generating image:", error);
    }
}

generateImage();
```

### Parameter Description

- `cfg`: Number, controls how closely the generated image adheres to the prompt. Higher values make the image more accurate but may reduce creativity.
- `prompt`: String, the text prompt describing the image you want to generate.
- `aspect_ratio`: String, specifies the aspect ratio of the output image, such as "3:2".
- `output_format`: String, specifies the format of the output image, here using "webp".
- `output_quality`: Number, specifies the quality of the output image, ranging from 0 to 100.
- `negative_prompt`: String, describes elements you do not want to appear in the generated image.

### Notes

- The quality and specificity of the prompt will directly affect the quality and accuracy of the generated image.
- The API may take some time to process the request and generate the image, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and copyright laws, especially in commercial use cases.

### Example Response

The API response will contain the URL of the generated image or other relevant information. Parse and use the response data according to the actual API documentation.

## Advanced Usage

- Implement batch image generation by processing multiple prompts in a loop or concurrent requests.
- Add a user interface that allows users to input custom prompts and parameters.
- Implement image post-processing features, such as resizing, cropping, or applying filters.
- Integrate an image storage solution to save and manage the generated images.

